/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.text.MessageFormat;
import java.util.Collections;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.AbstractInstallTask;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;

public class InstallerBundleUpdateTask
extends AbstractInstallTask {
    private static final String BUNDLE_UPDATE_ORDER = "02-";
    private final Integer count = (Integer)this.getResource().getAttribute("org.apache.sling.installer.api.tasks.ASyncInstallTask");

    public InstallerBundleUpdateTask(TaskResourceGroup r, TaskSupport taskSupport) {
        super(r, taskSupport);
    }

    @Override
    public void execute(InstallationContext ctx) {
        Bundle b = this.getBundleContext().getBundle();
        if (this.count == null) {
            try {
                b.update(this.getResource().getInputStream());
                ctx.log("Updated bundle {} from resource {}", b, this.getResource());
            }
            catch (Exception e) {
                String message = MessageFormat.format("Removing failing tasks due to {0} - unable to retry: {1}", e.getLocalizedMessage(), this);
                this.getLogger().info(message, e);
                this.setFinishedState(ResourceState.IGNORED, null, message);
                ctx.asyncTaskFailed(this);
            }
        } else if (this.count == 1) {
            this.getBundleRefresher().refreshBundles(ctx, Collections.singletonList(b), false);
        } else {
            this.getResource().setAttribute("org.apache.sling.installer.api.tasks.ASyncInstallTask", null);
            this.setFinishedState(ResourceState.INSTALLED, null, null);
        }
    }

    @Override
    public boolean isAsynchronousTask() {
        return this.count == null || this.count == 1;
    }

    @Override
    public String getSortKey() {
        return BUNDLE_UPDATE_ORDER + this.getResource().getEntityId();
    }
}

