/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.text.MessageFormat;
import java.util.Iterator;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.RetryHandler;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.BundleBlackList;
import org.apache.sling.installer.core.impl.EntityResourceList;
import org.apache.sling.installer.core.impl.InternalService;
import org.apache.sling.installer.core.impl.RegisteredResourceImpl;
import org.apache.sling.installer.core.impl.Util;
import org.apache.sling.installer.core.impl.tasks.BundleInfo;
import org.apache.sling.installer.core.impl.tasks.BundleInstallTask;
import org.apache.sling.installer.core.impl.tasks.BundleRemoveTask;
import org.apache.sling.installer.core.impl.tasks.BundleStartTask;
import org.apache.sling.installer.core.impl.tasks.BundleUpdateTask;
import org.apache.sling.installer.core.impl.tasks.BundleUtil;
import org.apache.sling.installer.core.impl.tasks.InstallerBundleUpdateTask;
import org.apache.sling.installer.core.impl.tasks.RestartActiveBundlesTask;
import org.apache.sling.installer.core.impl.tasks.SystemBundleUpdateTask;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleTaskCreator
implements InternalService,
InstallTaskFactory,
FrameworkListener,
BundleListener {
    private static final String FORCE_INSTALL_VERSION = "force.install.version";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TaskSupport taskSupport;
    private BundleContext bundleContext;
    private RetryHandler retryHandler;
    private BundleBlackList bundleBlacklist;

    @Override
    public void init(BundleContext bc, ResourceChangeListener listener, RetryHandler retryHandler) {
        this.bundleContext = bc;
        this.retryHandler = retryHandler;
        this.bundleContext.addBundleListener(this);
        this.bundleContext.addFrameworkListener(this);
        this.taskSupport = new TaskSupport(bc);
        this.bundleBlacklist = new BundleBlackList(bc);
    }

    @Override
    public void deactivate() {
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener(this);
            this.bundleContext.removeFrameworkListener(this);
        }
        if (this.taskSupport != null) {
            this.taskSupport = null;
        }
    }

    @Override
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 4) {
            this.logger.debug("Received FrameworkEvent triggering a retry of the installer: {}", (Object)event);
            this.retryHandler.scheduleRetry();
        }
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        int t = event.getType();
        if (t == 1 || t == 32 || t == 2 || t == 8) {
            this.logger.debug("Received BundleEvent triggering a retry of the installer: {}", (Object)event);
            this.retryHandler.scheduleRetry();
        }
    }

    @Override
    public String getDescription() {
        return "Apache Sling Bundle Install Task Factory";
    }

    @Override
    public InstallTask createTask(TaskResourceGroup resourceList) {
        InstallTask result;
        TaskResource toActivate = resourceList.getActiveResource();
        if (toActivate.getType().equals("org.apache.sling.installer.core.restart.bundles")) {
            return new RestartActiveBundlesTask(resourceList, this.taskSupport);
        }
        if (!toActivate.getType().equals("bundle")) {
            return null;
        }
        if (toActivate.getAttribute("Bundle-SymbolicName") == null) {
            Util.BundleHeaders headers = Util.readBundleHeaders(toActivate, this.logger);
            if (headers == null) {
                String message = MessageFormat.format("Resource of type bundle {0} is not really a bundle - manifest entries are missing.", toActivate);
                this.logger.info(message);
                return new ChangeStateTask(resourceList, ResourceState.IGNORED, message);
            }
            toActivate.setAttribute("Bundle-SymbolicName", headers.symbolicName);
            toActivate.setAttribute("Bundle-Version", headers.version);
            if (headers.activationPolicy != null) {
                toActivate.setAttribute("Bundle-ActivationPolicy", headers.activationPolicy);
            }
        }
        String symbolicName = (String)toActivate.getAttribute("Bundle-SymbolicName");
        boolean isInstallerCoreBundle = this.bundleContext.getBundle().getSymbolicName().equals(symbolicName);
        if (toActivate.getState() == ResourceState.UNINSTALL) {
            BundleInfo info = this.getBundleInfo(symbolicName, (String)toActivate.getAttribute("Bundle-Version"));
            if (info != null) {
                Iterator<TaskResource> candidatesIt = ((EntityResourceList)resourceList).getActiveResourceIterator();
                TaskResource second = null;
                while (candidatesIt != null && second == null && candidatesIt.hasNext()) {
                    TaskResource candidate = candidatesIt.next();
                    boolean sameVersion = toActivate.getVersion().equals(candidate.getVersion());
                    if (sameVersion) continue;
                    if (this.bundleBlacklist.isBlacklisted(symbolicName, candidate.getVersion())) {
                        String message = MessageFormat.format("Uninstalling blacklisted bundle {0} found at {1}", symbolicName, candidate.getURL());
                        this.logger.info(message);
                        ((RegisteredResourceImpl)candidate).setState(ResourceState.UNINSTALL, message);
                        continue;
                    }
                    second = candidate;
                }
                if (second != null && (second.getState() == ResourceState.IGNORED || second.getState() == ResourceState.INSTALLED || second.getState() == ResourceState.INSTALL)) {
                    second.setAttribute(FORCE_INSTALL_VERSION, info.version.toString());
                    BundleUtil.clearBundleStart(second);
                    this.logger.debug("Detected downgrade of bundle {}", (Object)symbolicName);
                    result = new ChangeStateTask(resourceList, ResourceState.UNINSTALLED, null);
                } else if (isInstallerCoreBundle) {
                    this.logger.debug("Prevent completely uninstalling installer bundle {}", (Object)symbolicName);
                    result = new ChangeStateTask(resourceList, ResourceState.UNINSTALLED, null);
                } else {
                    result = new BundleRemoveTask(resourceList, this.taskSupport);
                }
            } else {
                this.logger.debug("Bundle {}:{} is not installed anymore - nothing to remove.", (Object)symbolicName, toActivate.getAttribute("Bundle-Version"));
                result = new ChangeStateTask(resourceList, ResourceState.UNINSTALLED, null);
            }
        } else {
            Integer asyncTaskCounter = (Integer)toActivate.getAttribute("org.apache.sling.installer.api.tasks.ASyncInstallTask");
            if (asyncTaskCounter != null) {
                result = isInstallerCoreBundle ? new InstallerBundleUpdateTask(resourceList, this.taskSupport) : new ChangeStateTask(resourceList, ResourceState.INSTALLED, null, new String[]{"org.apache.sling.installer.api.tasks.ASyncInstallTask"}, null);
            } else {
                Version newVersion = new Version((String)toActivate.getAttribute("Bundle-Version"));
                if (this.bundleBlacklist.isBlacklisted(symbolicName, newVersion)) {
                    String message = MessageFormat.format("Ignoring blacklisted bundle {0} found at {1}", symbolicName, toActivate.getURL());
                    this.logger.info(message);
                    result = new ChangeStateTask(resourceList, ResourceState.IGNORED, message);
                } else {
                    BundleInfo info = this.getBundleInfo(symbolicName, null);
                    if (info == null) {
                        result = new BundleInstallTask(resourceList, this.taskSupport);
                    } else if (BundleUtil.isBundleStart(toActivate)) {
                        result = new BundleStartTask(resourceList, info.id, this.taskSupport);
                    } else {
                        boolean doUpdate = false;
                        int compare = info.version.compareTo(newVersion);
                        if (compare < 0) {
                            doUpdate = true;
                        } else if (compare > 0) {
                            String forceVersion = (String)toActivate.getAttribute(FORCE_INSTALL_VERSION);
                            if (forceVersion != null && info.version.compareTo(new Version(forceVersion)) == 0) {
                                doUpdate = true;
                            } else {
                                this.logger.debug("Bundle " + info.symbolicName + " " + newVersion + " is not installed, bundle with higher version is already installed.");
                            }
                        } else if (compare == 0 && BundleInfo.isSnapshot(newVersion)) {
                            doUpdate = true;
                        }
                        if (doUpdate) {
                            this.logger.debug("Scheduling update of {}", (Object)toActivate);
                            result = "system.bundle".equals(symbolicName) ? new SystemBundleUpdateTask(resourceList, this.taskSupport) : (isInstallerCoreBundle ? new InstallerBundleUpdateTask(resourceList, this.taskSupport) : new BundleUpdateTask(resourceList, this.taskSupport));
                        } else if (compare == 0 && (isInstallerCoreBundle || "system.bundle".equals(symbolicName))) {
                            result = new ChangeStateTask(resourceList, ResourceState.INSTALLED, "This is the system bundle, therefore nothing was actually done!");
                        } else {
                            String message = MessageFormat.format("Nothing to install for {0}, same or newer version {1} already installed.", toActivate, newVersion);
                            this.logger.debug(message);
                            result = new ChangeStateTask(resourceList, ResourceState.IGNORED, message);
                        }
                    }
                }
            }
            toActivate.setAttribute(FORCE_INSTALL_VERSION, null);
        }
        return result;
    }

    protected BundleInfo getBundleInfo(String symbolicName, String version) {
        return BundleInfo.getBundleInfo(this.bundleContext, symbolicName, version);
    }
}

