/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.core.impl.tasks.AbstractBundleTask;
import org.apache.sling.installer.core.impl.tasks.BundleStartTask;
import org.apache.sling.installer.core.impl.tasks.BundleUtil;
import org.apache.sling.installer.core.impl.tasks.RefreshBundlesTask;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;

public class BundleInstallTask
extends AbstractBundleTask {
    private static final String BUNDLE_INSTALL_ORDER = "40-";

    public BundleInstallTask(TaskResourceGroup r, TaskSupport creator) {
        super(r, creator);
    }

    @Override
    public void execute(InstallationContext ctx) {
        int startLevel = this.getBundleStartLevel();
        try {
            Bundle b = this.getBundleContext().installBundle(this.getResource().getURL(), this.getResource().getInputStream());
            ctx.log("Installed bundle {} from resource {}", b, this.getResource());
            if (startLevel > 0) {
                BundleStartLevel startLevelService = b.adapt(BundleStartLevel.class);
                startLevelService.setStartLevel(startLevel);
                ctx.log("Set start level for bundle {} to {}", b, startLevel);
            }
            if (BundleUtil.isSystemBundleFragment(b)) {
                this.setFinishedState(ResourceState.INSTALLED);
            } else {
                String fragmentHostHeader = BundleUtil.getFragmentHostHeader(b);
                if (fragmentHostHeader != null) {
                    this.getLogger().debug("Need to do a refresh of the bundle's {} host", (Object)b);
                    for (Bundle bundle : this.getBundleContext().getBundles()) {
                        if (!fragmentHostHeader.equals(bundle.getSymbolicName())) continue;
                        this.getLogger().debug("Found host bundle for {} to refresh: {}", (Object)b, (Object)bundle);
                        RefreshBundlesTask.markBundleForRefresh(ctx, this.getTaskSupport(), bundle);
                        break;
                    }
                    this.setFinishedState(ResourceState.INSTALLED);
                } else {
                    BundleUtil.markBundleStart(this.getResource());
                    ctx.addTaskToCurrentCycle(new BundleStartTask(this.getResourceGroup(), b.getBundleId(), this.getTaskSupport()));
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().info("Exception during install of bundle " + this.getResource() + " : " + ex.getMessage() + ". Retrying later.", ex);
        }
    }

    @Override
    public String getSortKey() {
        return BUNDLE_INSTALL_ORDER + this.getSortableStartLevel() + "-" + this.getResource().getURL();
    }
}

