/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.stats;

import com.adobe.granite.quickstart.base.impl.Main;
import com.adobe.granite.quickstart.base.impl.stats.Phase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;

public class StartupStatsProvider {
    private static final String TITLE = "Startup timeline";
    private static final String STARTUP_DESCRIPTION = "Startup";
    private static final String ENCODING = "UTF-8";
    private final String chartSize;
    private final SortedSet<Phase> phases = new TreeSet<Phase>();

    public StartupStatsProvider(String chartSize) {
        this.chartSize = chartSize;
        this.phases.add(new Phase(STARTUP_DESCRIPTION, Main.getJvmStartTime(), 0L));
    }

    public String getStatsUrl() {
        return this.computeUrl();
    }

    private static void stringList(StringBuilder result, Collection<Phase> data, String separator, Getter g) {
        boolean first = true;
        for (Phase p : data) {
            if (!first) {
                result.append(separator);
            }
            first = false;
            String value = g.get(p);
            try {
                result.append(URLEncoder.encode(value, ENCODING));
            }
            catch (UnsupportedEncodingException ue) {
                result.append(value);
            }
        }
    }

    private String computeUrl() {
        long min = Long.MAX_VALUE;
        long max = 0L;
        for (Phase p : this.phases) {
            min = Math.min(min, p.getStart());
            max = Math.max(max, p.getEnd());
        }
        final long start = min;
        long end = max;
        long range = end - start;
        StringBuilder b = new StringBuilder();
        b.append("http://chart.apis.google.com/chart?chtt=");
        try {
            b.append(URLEncoder.encode(TITLE, ENCODING));
        }
        catch (UnsupportedEncodingException ignore) {
            b.append(TITLE);
        }
        b.append("&cht=bhs");
        b.append("&chxt=x");
        b.append("&chco=c6d9fd,4d89f9");
        b.append("&chbh=a");
        b.append("&chds=0,");
        b.append(range);
        b.append(",0,");
        b.append(range);
        b.append("&chxr=0,0,");
        b.append(range);
        b.append("&chd=t:");
        StartupStatsProvider.stringList(b, this.phases, ",", new Getter(){

            @Override
            public String get(Phase p) {
                return String.valueOf(p.getStart() - start);
            }
        });
        b.append("|");
        StartupStatsProvider.stringList(b, this.phases, ",", new Getter(){

            @Override
            public String get(Phase p) {
                return String.valueOf(p.getElapsed());
            }
        });
        b.append("&chly=");
        StartupStatsProvider.stringList(b, this.phases, "|", new Getter(){

            @Override
            public String get(Phase p) {
                return p.getDescription();
            }
        });
        b.append("&chs=");
        b.append(this.chartSize);
        return b.toString();
    }

    void addPhase(Phase p) {
        this.phases.add(p);
    }

    static interface Getter {
        public String get(Phase var1);
    }
}

