/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.stats;

public class Phase
implements Comparable<Phase> {
    private final long start;
    private final long end;
    private final String description;

    public Phase(String description, long start, long end) {
        this.start = start;
        this.end = end;
        this.description = description;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end == 0L ? System.currentTimeMillis() : this.end;
    }

    public long getElapsed() {
        return this.getEnd() - this.getStart();
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.description + " (" + this.start + "/" + this.end + ")";
    }

    @Override
    public int compareTo(Phase o) {
        if (this.getStart() < o.getStart()) {
            return -1;
        }
        if (this.getStart() > o.getStart()) {
            return 1;
        }
        return this.getDescription().compareTo(o.getDescription());
    }
}

