/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.extension;

import com.adobe.granite.quickstart.base.impl.ProductProperties;
import com.adobe.granite.quickstart.base.impl.extension.Extension;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ExtensionRegistry {
    public static final String EXTENSION_PROPERTY_PREFIX = "x.";
    public static final String JAR_FILE_PROPERTY = "jar";
    public static final Set<String> MANDATORY_PROPERTIES = new HashSet<String>(){
        {
            this.add(ExtensionRegistry.JAR_FILE_PROPERTY);
        }
    };
    public static final String QS_SYS_PROP_PREFIX = "qs.";
    public static final String QS_SYS_PROP_WORKDIR = "qs.workdir";
    public static final String QS_SYS_PROP_SLING_HOME = "qs.sling.home";
    public static final String EXTENSIONS_HOME = "opt" + File.separator + "extensions";
    private Map<String, Extension> registry = new HashMap<String, Extension>();

    public ExtensionRegistry(ProductProperties productProperties, Properties slingProperties) {
        this.registerExtensionProperties(productProperties, slingProperties);
        this.extractExtensionsFromConfiguration(productProperties);
        this.validateExtensions();
    }

    public Extension getExtension(String name) {
        return this.registry.get(name);
    }

    private void extractExtensionsFromConfiguration(ProductProperties productProperties) {
        HashMap<String, Properties> extensionPropertiesMap = new HashMap<String, Properties>();
        for (Object object : productProperties.keySet()) {
            String property = (String)object;
            if (!property.startsWith(EXTENSION_PROPERTY_PREFIX)) continue;
            String namespacedExtensionProperty = property.substring(property.indexOf(46) + 1);
            String[] parts = namespacedExtensionProperty.split("\\.");
            if (parts.length != 2) {
                System.err.println("Invalid configuration property detected: " + property);
                System.err.println("Extensions should be configured using the following format: x.<extension_namespace>.<property>");
                continue;
            }
            String extensionNamespace = parts[0];
            String extensionProperty = parts[1];
            Properties extensionProperties = (Properties)extensionPropertiesMap.get(extensionNamespace);
            if (extensionProperties == null) {
                extensionProperties = new Properties();
                extensionPropertiesMap.put(extensionNamespace, extensionProperties);
            }
            extensionProperties.put(extensionProperty, productProperties.getProperty(property));
        }
        for (Map.Entry entry : extensionPropertiesMap.entrySet()) {
            String extensionName = (String)entry.getKey();
            try {
                Extension extension = new Extension(extensionName, (Properties)entry.getValue());
                this.registry.put(extensionName, extension);
            }
            catch (IOException e) {
                System.err.println(String.format("Cannot initialise extension %s: %s", extensionName, e.getMessage()));
            }
        }
    }

    private void validateExtensions() {
        for (Map.Entry<String, Extension> entry : this.registry.entrySet()) {
            Extension extension = entry.getValue();
            Properties extensionProperties = extension.getProperties();
            for (String mandatoryProperty : MANDATORY_PROPERTIES) {
                if (extensionProperties.containsKey(mandatoryProperty)) continue;
                System.err.println(String.format("Extension %s is missing mandatory property %s. The extension will not be used.", entry.getKey(), mandatoryProperty));
                this.registry.remove(entry.getKey());
            }
        }
    }

    private void registerExtensionProperties(ProductProperties productProperties, Properties slingProperties) {
        System.setProperty(QS_SYS_PROP_WORKDIR, productProperties.getProperty("workdir"));
        System.setProperty(QS_SYS_PROP_SLING_HOME, productProperties.getSlingHomeDir().getAbsolutePath());
    }
}

