/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.extension;

import com.adobe.granite.quickstart.base.impl.extension.ExtensionRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Extension {
    private static final String HEADER_SPECIFICATION_VERSION = "Specification-Version";
    private static final String HEADER_IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String HEADER_MAIN_CLASS = "Main-Class";
    private String name;
    private Properties properties;
    private JarFile jarFile;
    private String extensionVersion;
    private String mainClassName;
    private URL url;

    public Extension(String name, Properties properties) throws IOException {
        this.name = name;
        this.properties = properties;
        String jarFileName = properties.getProperty("jar");
        String jarFilePath = System.getProperty("qs.sling.home") + File.separator + ExtensionRegistry.EXTENSIONS_HOME + File.separator + jarFileName;
        File file = new File(jarFilePath);
        if (!file.exists()) {
            throw new IOException(String.format("Cannot find extension JAR %s.", jarFilePath));
        }
        this.url = file.toURI().toURL();
        this.jarFile = new JarFile(file);
        Manifest manifest = this.jarFile.getManifest();
        Attributes jarAttributes = manifest.getMainAttributes();
        this.extensionVersion = jarAttributes.getValue(HEADER_IMPLEMENTATION_VERSION);
        if (this.extensionVersion == null) {
            this.extensionVersion = jarAttributes.getValue(HEADER_SPECIFICATION_VERSION);
        }
        this.mainClassName = jarAttributes.getValue(HEADER_MAIN_CLASS);
        if (this.mainClassName == null) {
            throw new IllegalStateException(String.format("Extension JAR %s does not contain a main class.", jarFilePath));
        }
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getExtensionVersion() {
        return this.extensionVersion;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public URL getExtensionURL() {
        return this.url;
    }
}

