/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.exec;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Bootstrap {
    private final Map<String, String> startupProps;
    private final boolean verbose;
    private final String appDir;
    private static final String MAIN_CLASS_DEF = "org.apache.sling.launchpad.app.Main";
    private static final String DELIM = "-------------------------------------------------------------------";

    public Bootstrap(Map<String, String> startupProps, String appDir, boolean verbose) {
        if (appDir == null) {
            throw new IllegalArgumentException("Parameter appDir not specified.");
        }
        this.startupProps = startupProps;
        this.verbose = verbose;
        this.appDir = appDir;
    }

    public void run() throws Exception {
        if (this.verbose) {
            System.out.println(DELIM);
            System.out.println("Quickstart application directory: " + this.appDir);
        }
        ClassLoader cl = this.createClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        if (this.verbose) {
            System.out.println("Main class: org.apache.sling.launchpad.app.Main");
            System.out.println(DELIM);
        }
        Class<?> mainClass = Class.forName(MAIN_CLASS_DEF, true, cl);
        Constructor<?> constructor = mainClass.getDeclaredConstructor(Map.class);
        constructor.setAccessible(true);
        Object mainObject = constructor.newInstance(this.startupProps);
        if (this.startupProps.containsKey("sling.control.action")) {
            Method control = mainClass.getDeclaredMethod("doControlAction", new Class[0]);
            control.setAccessible(true);
            Integer rc = (Integer)control.invoke(mainObject, new Object[0]);
            if (rc >= 0) {
                // empty if block
            }
        }
        Method start = mainClass.getDeclaredMethod("doStart", new Class[0]);
        start.setAccessible(true);
        start.invoke(mainObject, new Object[0]);
    }

    private ClassLoader createClassLoader() throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        this.populateLibraries(list);
        URL[] urls = list.toArray(new URL[list.size()]);
        if (this.verbose) {
            System.out.println("App classpath: ");
            for (int i = 0; i < urls.length; ++i) {
                System.out.println(" - " + urls[i]);
            }
        }
        return new URLClassLoader(urls);
    }

    private void populateLibraries(List<URL> list) {
        File[] libs = new File(this.appDir).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                try {
                    list.add(libs[i].toURI().toURL());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

