/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl;

import com.adobe.granite.quickstart.base.impl.ProductProperties;
import com.adobe.granite.quickstart.base.impl.exec.Bootstrap;
import com.adobe.granite.quickstart.base.impl.exec.PortSelector;
import com.adobe.granite.quickstart.base.impl.exec.ResourceProvider;
import com.adobe.granite.quickstart.base.impl.exec.StandardStreamsHandler;
import com.adobe.granite.quickstart.base.impl.stats.Launcher;
import com.adobe.granite.quickstart.base.impl.ui.GuiFrame;
import com.adobe.granite.quickstart.base.impl.ui.UserInterface;
import com.adobe.granite.quickstart.base.impl.upgrade.UpgradeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class Quickstart {
    private static final String ADMIN_PASSWORD = "admin.password";
    private final File logDir;
    private final ProductProperties product;
    private final UserInterface ui;
    private final int port;
    private final boolean noBrowser;
    private final UpgradeUtil.Mode upgradeMode;
    private final String bindInterface;
    private final InetAddress bindAddress;
    private final boolean verbose;
    private final boolean noShutdownHook;
    private final String contextPath;
    private final Properties fwkProperties;
    private final int listenerPort;

    Quickstart(GuiFrame f, String portParam, String contextPath, String interfaceParam, ProductProperties instanceProperties, Properties fwkProperties, boolean verbose, boolean noShutdownHook, StandardStreamsHandler streams, boolean unpackOnly, boolean noBrowser, int listenerPort) throws Exception {
        this.fwkProperties = fwkProperties;
        this.listenerPort = listenerPort;
        this.contextPath = contextPath == null || contextPath.length() == 0 ? System.getProperty("org.apache.felix.http.context_path") : contextPath;
        this.verbose = verbose;
        this.noShutdownHook = noShutdownHook;
        this.product = instanceProperties;
        this.noBrowser = noBrowser;
        this.bindInterface = interfaceParam;
        this.bindAddress = interfaceParam == null ? null : InetAddress.getByName(interfaceParam);
        this.logDir = new File(this.product.getSlingHomeDir(), "logs");
        this.logDir.mkdirs();
        if (f == null && this.isFirstInstallation() && !this.skipRequestAdminPassword()) {
            this.requestAdminPassword();
        }
        Date start = new Date();
        if (verbose) {
            System.err.print("Verbose mode - stdout/err not redirected to files, and stdin not closed");
            streams.switchToOriginalStreams();
        } else {
            System.err.println("Verbose option not active, closing stdin and redirecting stdout and stderr");
            try {
                System.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            streams.switchToLogFiles(this.logDir);
            System.out.println("Quickstart startup at " + start);
        }
        ResourceProvider rp = new ResourceProvider(){

            @Override
            protected void debug(String format, Object ... args) {
                if (Quickstart.this.ui == null) {
                    System.err.println(String.format(format, args));
                } else {
                    Quickstart.this.ui.debug(String.format(format, args));
                }
            }
        };
        if (f != null) {
            f.initialize(rp, instanceProperties.getRequiredProperty("gui.window.title"), instanceProperties.getRequiredProperty("gui.window.icons").split(","));
        }
        this.ui = new UserInterface(f, verbose);
        this.ui.debug("quickstart.build=" + instanceProperties.getBuildInfo());
        if (!unpackOnly) {
            this.ui.debug("quickstartdir:" + this.product.getSlingHomeDir().getAbsolutePath());
            if (portParam.length() == 0) {
                portParam = instanceProperties.getRequiredProperty("ports.list");
            }
            this.port = new PortSelector(){

                @Override
                protected void debug(String str) {
                    Quickstart.this.ui.debug("PortSelector: " + str);
                }
            }.selectPort(portParam, this.bindAddress);
            instanceProperties.put("quickstart.port", String.valueOf(this.port));
        } else {
            this.port = 0;
        }
        UpgradeUtil upgradeUtil = new UpgradeUtil(this.product, this.ui);
        this.upgradeMode = upgradeUtil.handleInstallAndUpgrade(unpackOnly);
        if (this.upgradeMode == UpgradeUtil.Mode.INSTALL && unpackOnly) {
            upgradeUtil.resetUpgradeMode();
        }
    }

    private String getWelcomeUrl() throws Exception {
        String welcomePath;
        int pos;
        String root;
        StringBuilder builder = new StringBuilder("http://localhost");
        if (this.port != 80) {
            builder.append(':');
            builder.append(String.valueOf(this.port));
        }
        if ((root = this.contextPath) == null || root.length() == 0) {
            try {
                File f = this.product.getSlingPropertiesFile();
                if (f.exists()) {
                    Properties p = new Properties();
                    p.load(new FileInputStream(f.getAbsolutePath()));
                    root = p.getProperty("org.apache.felix.http.context_path");
                }
            }
            catch (Exception e) {
                System.err.println("Can't load http root property: " + e.toString());
            }
        }
        if (root != null && root.length() > 0) {
            if (!root.startsWith("/")) {
                builder.append('/');
            }
            builder.append(root);
        }
        if (!builder.toString().endsWith("/")) {
            builder.append('/');
        }
        if ((pos = (welcomePath = this.product.getRequiredProperty("welcome.page.url")).indexOf(":/")) > 0) {
            welcomePath = welcomePath.substring(pos + 2);
        }
        if (welcomePath.startsWith("/")) {
            welcomePath = welcomePath.substring(1);
        }
        builder.append(welcomePath);
        return builder.toString();
    }

    public void run() throws Exception {
        String slingHome = this.product.getSlingHomeDir().getAbsolutePath();
        String launchpadHome = this.product.getSlingLaunchpadHome();
        String slingProperties = this.product.getSlingPropertiesPath();
        this.ui.debug("Sling Home: " + slingHome);
        this.ui.debug("Launchpad Home: " + launchpadHome);
        this.ui.debug("Sling Properties: " + slingProperties);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("sling.home", slingHome);
        arguments.put("sling.launchpad", launchpadHome);
        arguments.put("sling.properties", slingProperties);
        arguments.put("org.osgi.service.http.port", String.valueOf(this.port));
        if (this.contextPath != null && this.contextPath.length() > 0) {
            arguments.put("org.apache.felix.http.context_path", this.contextPath);
        }
        if (this.product.get("use.controlport") != null) {
            arguments.put("sling.control.action", "start");
        }
        if (this.noShutdownHook) {
            arguments.put("sling.shutdown.hook", "false");
        }
        if (this.bindInterface != null) {
            // empty if block
        }
        if (System.getProperty("org.apache.sling.launchpad.startupmode") == null) {
            if (this.upgradeMode == UpgradeUtil.Mode.RESTART) {
                System.setProperty("org.apache.sling.launchpad.startupmode", "RESTART");
            } else if (this.upgradeMode == UpgradeUtil.Mode.INSTALL) {
                System.setProperty("org.apache.sling.launchpad.startupmode", "INSTALL");
            } else {
                System.setProperty("org.apache.sling.launchpad.startupmode", "UPDATE");
            }
        }
        for (String key : this.fwkProperties.stringPropertyNames()) {
            arguments.put(key, this.fwkProperties.getProperty(key));
        }
        this.ui.info(this.product.getProperty("gui.text.starting"));
        this.ui.debug("Application arguments: " + arguments);
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        jmxServer.registerMBean(new Launcher(this.ui, this.product, this.upgradeMode, this.getWelcomeUrl(), !this.noBrowser, this.listenerPort), new ObjectName("com.adobe.granite.quickstart:type=Launcher"));
        new Bootstrap(arguments, this.product.getSlingHomeDir().getAbsolutePath() + "/app", this.verbose).run();
    }

    private boolean isFirstInstallation() {
        boolean firstInstallation = false;
        File launchpadDir = new File(this.product.getSlingHomeDir(), "launchpad");
        if (!launchpadDir.exists()) {
            firstInstallation = true;
        }
        return firstInstallation;
    }

    private boolean skipRequestAdminPassword() {
        boolean skipRequestAdminPassword = false;
        if (this.product.get("no.interactive") != null || this.product.get("unpack") != null) {
            skipRequestAdminPassword = true;
        }
        return skipRequestAdminPassword;
    }

    private void requestAdminPassword() {
        if (System.console() != null) {
            String adminPassword;
            boolean valid = false;
            System.console().printf("%s", "The admin password for this instance hasn't been defined yet." + System.getProperty("line.separator"));
            do {
                if ((adminPassword = new String(System.console().readPassword("%s: ", "Please enter the desired admin password"))) == null || adminPassword.isEmpty()) {
                    valid = false;
                    continue;
                }
                String adminPasswordReentered = new String(System.console().readPassword("%s: ", "Please re-enter password"));
                if (adminPassword.equals(adminPasswordReentered)) {
                    valid = true;
                    continue;
                }
                System.err.println("Passwords do not match.");
                valid = false;
            } while (!valid);
            this.setPassword(adminPassword);
        }
    }

    private void setPassword(String adminPassword) {
        System.setProperty(ADMIN_PASSWORD, adminPassword);
    }
}

