/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ProductProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String PROP_WELCOME_PAGE_URL = "welcome.page.url";
    public static final String PROP_NAME = "quickstart.productName";
    public static final String PROP_VERSION = "quickstart.productVersion";
    public static final String PROP_SHORT_VERSION = "quickstart.productShortVersion";
    public static final String PROP_BUILD = "quickstart.build";
    public static final String PROP_COMPANY = "quickstart.company";
    public static final String PROP_ID = "quickstart.id";
    public static final String PROP_WORKDIR = "workdir";
    public static final String PROP_UPGRADE_FRAMEWORK_STARTLEVEL = "upgrade.framework.startlevel";
    public static final String PROP_FRAMEWORK_STARTLEVEL = "framework.startlevel";
    public static final String PROP_USE_CONTROL_PORT = "use.controlport";
    public static final String PROP_NO_INTERACTIVE = "no.interactive";
    public static final String PROP_UNPACK = "unpack";
    private File slingHomeDir;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public ProductProperties() throws Exception {
        this.loadProps("default");
        this.loadProps("instance");
        this.getRequiredProperty(PROP_ID);
        this.getRequiredProperty(PROP_VERSION);
        this.getRequiredProperty(PROP_BUILD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(String name) throws IOException {
        String resourceName = "/quickstart/quickstart-" + name + ".properties";
        System.out.println("Loading quickstart properties: " + name);
        URL url = this.getClass().getResource(resourceName);
        if (url == null) {
            throw new IOException(resourceName + " resource not found");
        }
        try (InputStream is = null;){
            is = url.openStream();
            this.load(is);
        }
    }

    public String getProductId() {
        return this.getProperty(PROP_ID);
    }

    public String getBuildInfo() {
        return this.getProperty(PROP_VERSION) + '.' + this.getProperty(PROP_BUILD);
    }

    private String getQuickstartDirName() {
        return this.getProperty(PROP_WORKDIR, this.getProductId() + "-quickstart");
    }

    public String getRequiredProperty(String key) throws Exception {
        String result = this.getProperty(key);
        if (result == null) {
            throw new Exception("Missing instance property '" + key + "'");
        }
        return result;
    }

    @Override
    public String getProperty(String key) {
        String value = super.getProperty(key);
        return value == null ? null : this.substVars(value.trim(), key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : this.substVars(value.trim(), key, null);
    }

    public void setParentDir(File parentDir) throws IOException {
        if (System.getenv("SLING_HOME") != null) {
            this.slingHomeDir = new File(System.getenv("SLING_HOME"));
        } else if (System.getProperty("sling.home") != null) {
            this.slingHomeDir = new File(System.getProperty("sling.home"));
        } else {
            if (parentDir == null) {
                throw new IllegalArgumentException("Parent directory is not set - unable to determine Sling home directory.");
            }
            this.slingHomeDir = new File(parentDir, this.getQuickstartDirName());
        }
        this.slingHomeDir = this.slingHomeDir.getCanonicalFile();
        this.slingHomeDir.mkdirs();
    }

    public File getSlingHomeDir() {
        if (this.slingHomeDir == null) {
            throw new IllegalArgumentException("Parent directory is not set - unable to determine Sling home directory.");
        }
        return this.slingHomeDir;
    }

    public String getSlingLaunchpadHome() {
        return "launchpad";
    }

    public String getSlingPropertiesPath() {
        return "conf/sling.properties";
    }

    public File getSlingPropertiesFile() {
        return new File(this.getSlingHomeDir(), "conf" + File.separatorChar + "sling.properties");
    }

    private String substVars(String val, String currentKey, Map<String, String> cycleMap) {
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            return val;
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String substValue = super.getProperty(variable);
        if (substValue == null) {
            substValue = System.getProperty(variable, substValue);
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = this.substVars(val, currentKey, cycleMap);
        return val;
    }
}

